// Geometry Shader  file "particlerender.geom"

#version 330 core

varying in vec4 vs_out_Position[1];
varying in vec3 vs_right[1];
varying in vec3 vs_up[1];

void main(void)
{
	vec3 right = vec3(vs_right[0]);
	vec3 up = vec3(vs_up[0]);

	gl_Position.x = vs_out_Position[0].x + right.x + up.x;
	gl_Position.y = vs_out_Position[0].y + right.y + up.y;
	gl_Position.z = vs_out_Position[0].z + right.z + up.z;
	gl_Position.w = 1.0;
	EmitVertex();

	gl_Position.x = vs_out_Position[0].x - right.x + up.x;
	gl_Position.y = vs_out_Position[0].y - right.y + up.y; 
	gl_Position.z = vs_out_Position[0].z - right.z + up.z; 
	gl_Position.w = 1.0;
	EmitVertex();

	gl_Position.x = vs_out_Position[0].x - right.x - up.x; 
	gl_Position.y = vs_out_Position[0].y - right.y - up.y;
	gl_Position.z = vs_out_Position[0].z - right.z - up.z;
	gl_Position.w = 1.0;
	EmitVertex();
	
	gl_Position.x = vs_out_Position[0].x + right.x - up.x; 
	gl_Position.y = vs_out_Position[0].y + right.y - up.y;
	gl_Position.z = vs_out_Position[0].z + right.z - up.z;
	gl_Position.w = 1.0;
	EmitVertex(); 
	EndPrimitive();
}